classdef  testProd < matlab.unittest.TestCase
    %TESTPROD Test overloaded product of elements
    
    methods(Test)
        
        function testEmpty(testCase)
            x = polysym.empty;
            testCase.verifyTrue(isempty(prod(x)))
        end
        
        function testDefault(testCase)
            x = polysym;
            testCase.verifyTrue(iszero(prod(x)))
        end
        
        function testRealScalar(testCase)
            x = polysym(pi);
            testCase.verifyEqual(prod(x),x);
        end
        
        function testCharScalar(testCase)
            x = polysym('x');
            testCase.verifyEqual(prod(x),x);
        end
        
        function testArrayOfOnes(testCase)
            x = polysym(ones(3,1));
            testCase.verifyEqual(prod(x),polysym(1))
        end
        
        function testRealVectorWithUnity(testCase)
            x = polysym(1:3);
            testCase.verifyEqual(prod(x),x(2)*x(3));
        end
        
        function testCharVector(testCase)
            x = polysym('x',[3 1]);
            testCase.verifyEqual(prod(x),x(1)*x(2)*x(3));
        end
        
        function testMatrix(testCase)
            x = polysym('x',2);
            testCase.verifyEqual(prod(x),x(1,:).*x(2,:));
        end
        
        function testMatrixSecondDim(testCase)
            x = polysym('x',2);
            testCase.verifyEqual(prod(x,2),x(:,1).*x(:,2));
        end
        
        function testDimTooLarge(testCase)
            polysyms('x')
            f = @() x.prod(3);
            testCase.verifyError(f,'MATLAB:polysym:diff:notLess')
        end
        
        function testDimTooSmall(testCase)
            polysyms('x')
            f = @() x.prod(0);
            testCase.verifyError(f,'MATLAB:polysym:diff:notGreater')
            
        end
    end
end