classdef  testPolyval < matlab.unittest.TestCase
    %TESTPOLYVAL Test overloaded polynomial evaluation
    
    properties
        p = {1:3, polysym('p',[1 3])};
        x = {2, [1 2; 3 4], polysym(2)};
    end
    
    methods(Test)
        
        function testNoValue(testCase)
            for ii=1:numel(testCase.p)
                f = @() polyval(testCase.p{ii});
                testCase.verifyError(f,'MATLAB:minrhs')
            end
        end
        
        function testEmptyValue(testCase)
            a = []; x0 = polysym(1);
            y = polyval(a,x0);
            testCase.verifyEqual(y,polysym(0))
        end
        
        function testEmptyParam(testCase)
            a = polysym(1); x0 = [];
            y = polyval(a,x0);
            testCase.verifyEqual(y,polysym.empty)
        end
        
        function mixedTest(testCase)
            for ii=1:numel(testCase.p)
                for jj=1:numel(testCase.x)
                    y = polyval(testCase.p{ii},testCase.x{jj});
                    testCase.verifyEqual(y,testCase.x{jj}.* ...
                        (testCase.x{jj}*testCase.p{ii}(1)+testCase.p{ii}(2))+testCase.p{ii}(3));
                end
            end
        end
    end
end