classdef  testMtimes < matlab.unittest.TestCase
    %TESTMTIMES Test overloaded matrix multiplication
    
    methods(Test)
        
        function testZeros(testCase)
            x = polysym(0);
            y = polysym(0);
            z = x*y;
            testCase.verifyEqual(z.Value,'0');
        end
        
        function testOneZero(testCase)
            x = polysym(0);
            y = polysym('y');
            z = x*y;
            testCase.verifyEqual(z.Value,'0');
        end
        
        function testZeroMtimesReal(testCase)
            x = polysym(0);
            y = polysym(pi);
            z = x*y;
            testCase.verifyEqual(z.Value,'0');
        end
        
        function testRealMtimesChar(testCase)
            x = polysym('x');
            y = polysym(5);
            z = x*y;
            testCase.verifyEqual(z.Value,'x*5');
        end
        
        function testScalarMtimesVector(testCase)
            x = polysym('x');
            y = polysym(1:3);
            z = x*y;
            testCase.verifyEqual(z(1).Value,'x');
            testCase.verifyEqual(z(2).Value,'x*2');
            testCase.verifyEqual(z(3).Value,'x*3');
        end
        
        function testVectorMtimesScalar(testCase)
            x = polysym('x');
            y = polysym(1:3);
            z = y*x;
            testCase.verifyEqual(z(1).Value,'x');
            testCase.verifyEqual(z(2).Value,'2*x');
            testCase.verifyEqual(z(3).Value,'3*x');
        end
        
        function testRowVectorMtimesRowVector(testCase)
            x = polysym({'x','y'});
            y = polysym({'u','w'});
            f = @() x*y;
            testCase.verifyError(f,'polysym:mtimes:innerdim')
        end
        
        function testRowVectorMtimesColumnVector(testCase)
            x = polysym({'x','y'});
            y = polysym({'u','w'});
            z = x*y.';
            testCase.verifyEqual(z.Value,'x*u+y*w')
        end
        
        function testMtimesTimes(testCase)
            x = polysym('x');
            y = polysym('4.*y');
            z = x*y;
            testCase.verifyEqual(z.Value,'x*4.*y');
        end
        
        function testMtimesMtimes(testCase)
            x = polysym('x');
            y = polysym('4*y');
            z = x*y;
            testCase.verifyEqual(z.Value,'x*4*y');
            
        end
    end
end
