classdef  testMrdivide < matlab.unittest.TestCase
    %TESTMRDIVIDE Test overloaded right matrix divide
    
    methods(Test)
        
        function testZeroDividedByReal(testCase)
            x = polysym(0);
            y = polysym(rand);
            z = x/y;
            testCase.verifyTrue(z.Value=='0');
        end
        
        function testZeroDividedByChar(testCase)
            x = polysym(0);
            y = polysym('y');
            z = x/y;
            testCase.verifyTrue(z.Value=='0');
        end
        
        function testZeroDividedByZero(testCase)
            x = polysym(0);
            f = @() x/0;
            testCase.verifyError(f,'polysym:mrdivide:DivideByZero')
        end
        
        function testCharDividedByZero(testCase)
            x = polysym('x');
            f = @() x/0;
            testCase.verifyError(f,'polysym:mrdivide:DivideByZero')
        end
        
        function testCharDividedByInteger(testCase)
            x = polysym('x');
            z = x/5;
            testCase.verifyEqual(z.Value,'x/5');
        end
        
        function testCharDividedByReal(testCase)
            x = polysym('x');
            y = polysym(pi);
            z = x/y;
            testCase.verifyEqual(z.Value,['x/',y.Value]);
        end
        
        function testRealDividedByChar(testCase)
            x = polysym(pi);
            y = polysym('y');
            z = x/y;
            testCase.verifyEqual(z.Value,[x.Value,'/y']);
        end
        
        function testScalarDividedByVector(testCase)
            x = polysym('x');
            f = @() x/(1:3);
            testCase.verifyError(f,'polysym:mrdivide:NotScalar')
        end
        
        function testVectorDividedByVector(testCase)
            x = polysym({'x','y'});
            y = polysym({'u','w'});
            f = @() x/y;
            testCase.verifyError(f,'polysym:mrdivide:NotScalar')
        end
        
        function testDivDiv(testCase)
            % NOTE: This result is undesirable.
            x = polysym('x');
            y = polysym('4/y');
            z = x/y;
            testCase.verifyEqual(z.Value,'x/4/y');
            
        end
    end
end