classdef  testMldivide < matlab.unittest.TestCase
    %TESTMLDIVIDE Test overloaded left matrix divide
    
    methods(Test)
        
        function testZeroDividedByReal(testCase)
            x = polysym(0);
            y = polysym(rand);
            z = y\x;
            testCase.verifyTrue(z.Value=='0');
        end
        
        function testZeroDividedByChar(testCase)
            x = polysym(0);
            y = polysym('y');
            z = y\x;
            testCase.verifyTrue(z.Value=='0');
        end
        
        function testZeroDividedByZero(testCase)
            x = polysym(0);
            f = @() 0\x;
            testCase.verifyError(f,'polysym:mldivide:DivideByZero')
        end
        
        function testCharDividedByZero(testCase)
            x = polysym('x');
            f = @() 0\x;
            testCase.verifyError(f,'polysym:mldivide:DivideByZero')
        end
        
        function testCharDividedByInteger(testCase)
            x = polysym('x');
            z = 5\x;
            testCase.verifyEqual(z.Value,'x/5');
        end
        
        function testCharDividedByReal(testCase)
            x = polysym('x');
            y = polysym(pi);
            z = y\x;
            testCase.verifyEqual(z.Value,['x/',y.Value]);
        end
        
        function testRealDividedByChar(testCase)
            x = polysym(pi);
            y = polysym('y');
            z = y\x;
            testCase.verifyEqual(z.Value,[x.Value,'/y']);
        end
        
        function testScalarDividedByVector(testCase)
            x = polysym('x');
            f = @() (1:3)\x;
            testCase.verifyError(f,'polysym:mldivide:NotScalar')
        end
        
        function testVectorDividedByVector(testCase)
            x = polysym({'x','y'});
            y = polysym({'u','w'});
            f = @() y\x;
            testCase.verifyError(f,'polysym:mldivide:NotScalar')
        end
        
        function testDivDiv(testCase)
            % NOTE: This result is undesirable.
            x = polysym('x');
            y = polysym('4/y');
            z = y\x;
            testCase.verifyEqual(z.Value,'x/4/y');
            
        end
    end
end