classdef  testMakeSameSize < matlab.unittest.TestCase
    %TESTMAKESAMESIZE Test protected method for making arrays same size
    
    methods(Test)
        function testBothScalar(testCase)
            out = callMakeSameSize(1,1);
            testCase.verifyEqual(numel(out),1);
            testCase.verifyEqual(out.newValue1,'1');
            testCase.verifyEqual(out.newValue2,'1');
        end
        
        function testZeroScalars(testCase)
            in1 = 0;
            in2 = 0;
            out = callMakeSameSize(in1,in2);
            testCase.verifyEqual(numel(out),1);
            testCase.verifyEqual(out.newValue1,'0');
            testCase.verifyEqual(out.newValue2,'0');
        end
        
        function testFirstVector(testCase)
            in1 = [1 2];
            in2 = 3;
            out = callMakeSameSize(in1,in2);
            testCase.verifyEqual(numel(out),2);
            testCase.verifyEqual(out(1).newValue1,'1');
            testCase.verifyEqual(out(2).newValue1,'2');
            testCase.verifyEqual(out(1).newValue2,'3');
            testCase.verifyEqual(out(2).newValue2,'3');
        end
        
        function testSecondVector(testCase)
            in2 = [1 2];
            in1 = 3;
            out = callMakeSameSize(in1,in2);
            testCase.verifyEqual(numel(out),2);
            testCase.verifyEqual(out(1).newValue1,'3');
            testCase.verifyEqual(out(2).newValue1,'3');
            testCase.verifyEqual(out(1).newValue2,'1');
            testCase.verifyEqual(out(2).newValue2,'2');
        end
        
        function testCell(testCase)
            in1 = 's';
            in2 = {'t','u'};
            out = callMakeSameSize(in1,in2);
            testCase.verifyEqual(numel(out),2);
            testCase.verifyEqual(out(1).newValue1,'s');
            testCase.verifyEqual(out(2).newValue1,'s');
            testCase.verifyEqual(out(1).newValue2,'t');
            testCase.verifyEqual(out(2).newValue2,'u');
        end
        
        function testMatrix(testCase)
            in1 = 's';
            in2 = [1 2; 3 4];
            out = callMakeSameSize(in1,in2);
            testCase.verifyEqual(size(out,1),2);
            testCase.verifyEqual(size(out,2),2);
            testCase.verifyEqual(out(1,1).newValue1,'s');
            testCase.verifyEqual(out(1,2).newValue1,'s');
            testCase.verifyEqual(out(2,1).newValue1,'s');
            testCase.verifyEqual(out(2,2).newValue1,'s');
            testCase.verifyEqual(out(1,1).newValue2,'1');
            testCase.verifyEqual(out(1,2).newValue2,'2');
            testCase.verifyEqual(out(2,1).newValue2,'3');
            testCase.verifyEqual(out(2,2).newValue2,'4');
            
        end
    end
end