classdef  testLdivide < matlab.unittest.TestCase
    %TESTLDIVIDE Test overloaded left division
    
    methods(Test)
        
        function testZeroDividedByReal(testCase)
            x = polysym(0);
            y = polysym(rand);
            z = y.\x;
            testCase.verifyTrue(z.Value=='0');
        end
        
        function testZeroDividedByChar(testCase)
            x = polysym(0);
            y = polysym('y');
            z = y.\x;
            testCase.verifyTrue(z.Value=='0');
        end
        
        function testZeroDividedByZero(testCase)
            x = polysym(0);
            f = @() 0.\x;
            testCase.verifyError(f,'polysym:ldivide:DivideByZero')
        end
        
        function testCharDividedByZero(testCase)
            x = polysym('x');
            f = @() 0.\x;
            testCase.verifyError(f,'polysym:ldivide:DivideByZero')
        end
        
        function testCharDividedByInteger(testCase)
            x = polysym('x');
            z = 5.\x;
            testCase.verifyEqual(z.Value,'x/5');
        end
        
        function testCharDividedByReal(testCase)
            x = polysym('x');
            y = polysym(pi);
            z = y.\x;
            testCase.verifyEqual(z.Value,['x/',y.Value]);
        end
        
        function testRealDividedByChar(testCase)
            x = polysym(pi);
            y = polysym('y');
            z = y.\x;
            testCase.verifyEqual(z.Value,[x.Value,'/y']);
            
            % From documentation: If either OBJ1 or OBJ2 is a scalar, it is expanded to
            % an array of the same dimensions as the other input.
        end
        
        function testScalarDividedByVector(testCase)
            x = polysym('x');
            y = polysym(1:3);
            z = y.\x;
            testCase.verifyEqual(z(1).Value,'x');
            testCase.verifyEqual(z(2).Value,'x/2');
            testCase.verifyEqual(z(3).Value,'x/3');
            
        end
        
        function testVectorDividedByVector(testCase)
            x = polysym({'x','y'});
            y = polysym({'u','w'});
            z = y.\x;
            testCase.verifyEqual(z(1).Value,'x/u');
            testCase.verifyEqual(z(2).Value,'y/w');
        end
        
        function testDivDiv(testCase)
            % NOTE: This result is undesirable.
            x = polysym('x');
            y = polysym('4/y');
            z = y.\x;
            testCase.verifyEqual(z.Value,'x/4/y');
            
        end
    end
end
