classdef  testIszero < matlab.unittest.TestCase
    %TESTISZERO Test hidden method for comparing value with zero
    
    methods(Test)
        
        
        function testEmpty(testCase)
            x = polysym.empty;
            testCase.verifyEqual(iszero(x),logical.empty)
        end
        
        function testDefault(testCase)
            x = polysym;
            testCase.verifyTrue(iszero(x));
        end
        
        function testNumericZero(testCase)
            x = polysym(0);
            testCase.verifyTrue(iszero(x));
        end
        
        function testCharZeroNoPadding(testCase)
            x = polysym('0');
            testCase.verifyTrue(iszero(x));
        end
        
        function testCharZeroWithLeadingBlank(testCase)
            x = polysym(' 0');
            testCase.verifyTrue(iszero(x));
        end
        
        function testCharZeroWithTrailingBlank(testCase)
            x = polysym('0 ');
            testCase.verifyTrue(iszero(x));
        end
        
        function testCharZeroWithLeadingTab(testCase)
            x = polysym(sprintf('\t 0'));
            testCase.verifyTrue(iszero(x));
        end
        
        function testCharZeroWithTrailingTab(testCase)
            x = polysym(sprintf('0\t'));
            testCase.verifyTrue(iszero(x));
        end
        
        function testCharZeroWithDecimal(testCase)
            x = polysym('0.00');
            testCase.verifyTrue(iszero(x));
            
        end
    end
end