classdef  testIsone < matlab.unittest.TestCase
    %TESTISONE Test hidden method for comparing value with 1
    
    methods(Test)
        
        function testNumericOne(testCase)
            x = polysym(1);
            testCase.verifyTrue(isone(x));
        end
        
        function testCharOneNoPadding(testCase)
            x = polysym('1');
            testCase.verifyTrue(isone(x));
        end
        
        function testCharOneWithLeadingBlank(testCase)
            x = polysym(' 1');
            testCase.verifyTrue(isone(x));
        end
        
        function testCharOneWithTrailingBlank(testCase)
            x = polysym('1 ');
            testCase.verifyTrue(isone(x));
        end
        
        function testCharOneWithLeadingTab(testCase)
            x = polysym(sprintf('\t 1'));
            testCase.verifyTrue(isone(x));
        end
        
        function testCharOneWithTrailingTab(testCase)
            x = polysym(sprintf('1\t'));
            testCase.verifyTrue(isone(x));
        end
        
        function testWithDecimal(testCase)
            x = polysym('1.00');
            testCase.verifyTrue(isone(x));
        end
        
        function testWithExponent(testCase)
            x = polysym('1e0');
            testCase.verifyTrue(isone(x));
        end
        
        function testMixedDecimalExponent(testCase)
            x = polysym('1.00e0');
            testCase.verifyTrue(isone(x))
        end
    end
end