classdef  testHorzcat < matlab.unittest.TestCase
    %TESTHORZCAT Test overloaded horzcat method
    
    methods(Test)
        
        function testEmpty(testCase)
            y = horzcat(polysym.empty);
            testCase.verifyTrue(isempty(y))
        end
        
        function testDefault(testCase)
            y = horzcat(polysym);
            testCase.verifyEqual(y,polysym)
        end
        
        function testRowVector(testCase)
            polysyms('x','y','z')
            w =  horzcat(x,y,z);
            testCase.verifyEqual(w,polysym({'x','y','z'}))
        end
        
        function testColumns(testCase)
            polysyms one two three four five six
            w = horzcat([one; two; three],[four; five; six]);
            testCase.verifyEqual(w,polysym({'one', 'four'; 'two', 'five'; 'three', 'six'}))
        end
        
        function testPartlyEmpty(testCase)
            e = polysym.empty;
            one = polysym('1');
            two = polysym('2');
            v = horzcat(e,one,two);
            testCase.verifyEqual(v,polysym([[] 1 2]))
        end
        
        function testPartlyEmptyMultipleRows(testCase)
            e = polysym.empty;
            one = polysym('1');
            two = polysym('2');
            v = [e, one; one; e; e, two];
            testCase.verifyEqual(v,polysym([[],1; 1, []; [], 2]))
        end
        
        function testMixedClass(testCase)
            p1 = polysym('x'); p2 = 'y';
            v = horzcat(p1,p2);
            testCase.verifyEqual(v,polysym({'x','y'}))
            
        end
    end
end