classdef  testFormat_equations < matlab.unittest.TestCase
    %TESTFORMAT_EQUATIONS Test method for formatating equations
    
    methods(Test)
        
        function testOneInput(testCase)
            x = polysym('x');
            f = @() format_equations(x);
            if verLessThan('matlab','7.13.0')
                testCase.verifyError(f,'MATLAB:inputArgUndefined')
            else
                testCase.verifyError(f,'MATLAB:minrhs')
            end
        end
        
        function testMultipleEqnsPolysymLHS(testCase)
            x = polysym({'x','y'});
            LHS = polysym({'u','v'});
            out = format_equations(x,LHS);
            testCase.verifyEqual(out,{'x=u','y=v'})
            
        end
    end
end