classdef  testExp < matlab.unittest.TestCase
    %TESTEXP Test overloaded exponential function
    
    methods(Test)
        
        function testEmpty(testCase)
            p = polysym.empty;
            testCase.verifyEqual(exp(p),polysym.empty)
        end
        
        function testDefault(testCase)
            % Recall that the default value is 0.
            p = polysym;
            testCase.verifyEqual(exp(p),polysym(1))
        end
        
        function testScalar(testCase)
            polysyms('x')
            p = exp(x);
            testCase.verifyEqual(p,polysym('exp(x)'))
        end
        
        function testVector(testCase)
            x = polysym('x',[1 2]);
            p = exp(x);
            testCase.verifyEqual(p,polysym({'exp(x1)','exp(x2)'}))
            
        end
    end
end