classdef  testEq < matlab.unittest.TestCase
    %TESTEQ Test overloaded eq
    
    methods(Test)
        
        function testEmpty(testCase)
            p = polysym.empty;
            q = polysym.empty;
            testCase.verifyTrue(isempty(p==q))
        end
        
        function testDefault(testCase)
            p = polysym;
            q = polysym;
            testCase.verifyTrue(p==q)
        end
        
        function testDefaultAndEmpty(testCase)
            p = polysym;
            q = polysym.empty;
            testCase.verifyTrue(isempty(p==q))
        end
        
        function testDifferentScalars(testCase)
            polysyms('x','y')
            testCase.verifyTrue(~(x==y))
        end
        
        function testScalarVectorEqual(testCase)
            polysyms('x')
            p = [x x x];
            testCase.verifyEqual(p==x,true(size(p)))
        end
        
        function testScalarVectorNotEqual(testCase)
            polysyms('x','y')
            p = [x y x];
            testCase.verifyEqual(p==x,[true false true])
        end
        
        function testMatrices(testCase)
            polysyms('x','y')
            p = [x y; y x];
            q = [x x; y x];
            testCase.verifyEqual(p==q,[true false; true true])
            
        end
    end
end