classdef  testCtranspose < matlab.unittest.TestCase
    %TESTCTRANSPOSE Test overloaded complex transpose
    
    properties
        ctwarn
    end
    
    methods(TestMethodSetup)
        function setup(testCase)
            % Clear warnings and suppress the display of the warning by CTRANSPOSE.
            lastwarn('');
            testCase.ctwarn = 'polysym:ctranspose:noConjugate';
            warning('off',testCase.ctwarn)
        end
    end
    
    methods(Test)
        function testEmpty(testCase)
            p = polysym.empty;
            q = p';
            [~,msgid] = lastwarn;
            testCase.verifyTrue(isempty(q))
            testCase.verifyEqual(msgid,testCase.ctwarn)
        end
        
        function testDefault(testCase)
            p = polysym;
            q = p';
            [~,msgid] = lastwarn;
            testCase.verifyEqual(p,q.')
            testCase.verifyEqual(msgid,testCase.ctwarn)
        end
        
        function testNumeric(testCase)
            % The only difference between ctranspose (') and transpose (.') is that the
            % former gives a warning.
            p = polysym(randi(100,3));
            q = p';
            [~,msgid] = lastwarn;
            testCase.verifyEqual(p,q.')
            testCase.verifyEqual(msgid,testCase.ctwarn)
        end
    end
    
    methods(TestMethodTeardown)
        function teardown(testCase)
            warning('on',testCase.ctwarn)
        end
    end
end
