classdef  testCross < matlab.unittest.TestCase
    %TESTCROSS Test overloaded cross product
    
    methods(Test)
        
        
        function testEmpty(testCase)
            p = polysym.empty;
            q = polysym.empty;
            f = @() cross(p,q);
            testCase.verifyError(f,'polysym:cross:InvalidDimAorB')
        end
        
        function testNotSameSize(testCase)
            p = polysym(zeros(3,1));
            q = p.';
            f = @() cross(p,q);
            testCase.verifyError(f,'polysym:cross:InputSizeMismatch')
        end
        
        function testRowVectors(testCase)
            x = polysym('x',[1 3]);
            y = polysym('y',[1 3]);
            testCase.verifyEqual(cross(x,y),[x(2)*y(3)-x(3)*y(2) x(3)*y(1)-x(1)*y(3) x(1)*y(2)-x(2)*y(1)])
        end
        
        function testZeroComponent(testCase)
            % Note the parentheses around (x(2)*y(1)). This forces evaluation using
            % uminus; otherwise, the result is (-x2)*y1.
            x = polysym('x',[1 3]);
            y = polysym('y',[1 3]);
            x(1) = 0;
            testCase.verifyEqual(cross(x,y),[x(2)*y(3)-x(3)*y(2) x(3)*y(1) -(x(2)*y(1))])
        end
        
        function testColumnVectors(testCase)
            x = polysym('x',[3 1]);
            y = polysym('y',[3 1]);
            testCase.verifyEqual(cross(x,y),[x(2)*y(3)-x(3)*y(2); x(3)*y(1)-x(1)*y(3); x(1)*y(2)-x(2)*y(1)])
        end
        
        function testMatrices(testCase)
            x = polysym([0 0 1; 0 0 1; 0 0 1]);
            y = polysym('y',3);
            M = polysym(zeros(3));
            M(:,3) = y([3 1 2],3)-y([2 3 1],3);
            testCase.verifyEqual(cross(x,y),M)
        end
        
        function testMatricesSecondDim(testCase)
            x = polysym([0 0 1; 0 0 1; 0 0 1]);
            y = polysym('y',3);
            M = polysym(zeros(3));
            M(:,1) = -y(:,2);
            M(:,2) = y(:,1);
            testCase.verifyEqual(cross(x,y,2),M)
            
        end
    end
end