classdef  testCheckParens < matlab.unittest.TestCase
    %TESTCHECKPARENS Test protected method checkParens
    methods(Test)
        
        function testNullInput(testCase)
            out = callCheckParens('[]');
            testCase.verifyEqual(out.Value,'[]');
        end
        
        function testEmptyParens(testCase)
            out = callCheckParens('()');
            testCase.verifyEqual(out.Value,'()')
        end
        
        function testCharInput(testCase)
            out = callCheckParens('s');
            testCase.verifyEqual(out.Value,'s');
        end
        
        function testAddition(testCase)
            out = callCheckParens('s+t');
            testCase.verifyEqual(out.Value,'(s+t)');
        end
        
        function testAdditionWithParens(testCase)
            out = callCheckParens('(s+t)');
            testCase.verifyEqual(out.Value,'(s+t)');
        end
        
        function testSubtraction(testCase)
            out = callCheckParens('s-t');
            testCase.verifyEqual(out.Value,'(s-t)');
        end
        
        function testSubtractionWithParens(testCase)
            out = callCheckParens('(s-t)');
            testCase.verifyEqual(out.Value,'(s-t)');
        end
        
        function testMixedExpression(testCase)
            out = callCheckParens('s*t+1');
            testCase.verifyEqual(out.Value,'(s*t+1)');
        end
        
        function testNestedParens(testCase)
            out = callCheckParens('s+(t+u)');
            testCase.verifyEqual(out.Value,'(s+(t+u))');
        end
        
        function testUnbalancedParens(testCase)
            f = @() callCheckParens('((0)');
            testCase.verifyError(f,'polysym:polysym:unbalanceParens')
        end
    end
end