classdef  testCharBase < matlab.unittest.TestCase
    %TESTCHARBASE Test method char_base
    methods(Test)
        
        function testEmpty(testCase)
            p = polysym.empty;
            testCase.verifyTrue(isempty(p.char_base))
        end
        
        function testDefault(testCase)
            p = polysym;
            testCase.verifyEqual(p.char_base,{'0'})
        end
        
        function testSingleChar(testCase)
            p = polysym('x');
            testCase.verifyEqual(p.char_base,{'x'})
        end
        
        function testSingleArray(testCase)
            p = polysym('x',[2 3]);
            testCase.verifyEqual(p.char_base,repmat({'x'},[1 6]))
        end
        
        function testIncompleteArray(testCase)
            polysyms('x1_2','x2_3')
            p = [x1_2 x2_3];
            testCase.verifyEqual(p.char_base,repmat({'x'},[1 2]))
        end
        
        function testColumnVector(testCase)
            p = polysym('x',[3 1]);
            testCase.verifyEqual(p.char_base,repmat({'x'},[1 3]))
        end
        
        function testRowVector(testCase)
            p = polysym('x',[1 3]);
            testCase.verifyEqual(p.char_base,repmat({'x'},[1 3]))
        end
        
        function testMultipleChars(testCase)
            polysyms('x','y')
            p = [x y];
            testCase.verifyEqual(p.char_base,{'x','y'})
        end
        
        function testMixed(testCase)
            % If there is more than one array, they are returned as a list of
            % components.
            polysyms('x')
            p = polysym('w',2);
            v = [p(:); x];
            testCase.verifyEqual(v.char_base,[repmat({'w'},[1 4]) {'x'}])
        end

        function testZeroIndex(testCase)
            polysyms l0 l1
            v = [l0 l1];
            testCase.verifyEqual(v.char_base,{'l','l'})
            
        end
    end
end
