classdef  testCellstr < matlab.unittest.TestCase
    %TESTCELLSTR Test method cellstr
    methods(Test)
        
        function testEmpty(testCase)
            p = polysym.empty;
            testCase.verifyTrue(isempty(cellstr(p)))
        end
        
        function testDefault(testCase)
            p = polysym;
            testCase.verifyEqual(cellstr(p),{'0'})
        end
        
        function testRandNumeric(testCase)
            r = rand;
            p = polysym(r);
            precision = floor(log10(r/eps(r)));
            testCase.verifyEqual(cellstr(p),{num2str(r,precision)})
        end
        
        function testCos(testCase)
            p = polysym('x');
            q = cos(p);
            testCase.verifyEqual(cellstr(q),{'cos(x)'})
            
            % "returns ... a cell array of strings with the same dimensions as OBJ."
        end
        
        function testArray(testCase)
            r = randi(100,3);
            p = polysym(r);
            testCase.verifyEqual(cellstr(p),cellfun(@num2str,num2cell(r),'UniformOutput',false))
            
            % "Any objects that are equivalent to zero are represented by the string
            % '0'."
        end
        
        function testZeroChar(testCase)
            p = polysym('0');
            testCase.verifyEqual(cellstr(p),{'0'})
        end
        
        function testZeroNumeric(testCase)
            p = polysym(0);
            testCase.verifyEqual(cellstr(p),{'0'})
        end
        
        function testZeroCell(testCase)
            p = polysym({'0'});
            testCase.verifyEqual(cellstr(p),{'0'})
            
        end
    end
end
