function test_suite = testFormat_array %#ok<*STOUT>
initTestSuite;

function testNoInput %#ok<*DEFNU>
p = polysym;
out = format_array(p);
assertEqual(out,'0');

function testCharInput
p = polysym('s');
out = format_array(p);
assertEqual(out,'s');

function testCellInput
p = polysym({'s'});
out = format_array(p);
assertEqual(out,'s');

function testCellVectorInput
p = polysym({'s','t'});
out = format_array(p);
assertEqual(out,'s t')

function testCellArrayInput
p = polysym({'p','q'; 'r','s'});
out = format_array(p);
assertEqual(out,'p r q s')

function testDoubleInput
p = polysym(pi);
out = format_array(p);
assertEqual(out,num2str(pi,15));

function testDoubleVectorInput
p = polysym([1 2]);
out = format_array(p);
assertEqual(out,'1 2')

function testDoubleMatrixInput
p = polysym([1 2; 3 4]);
out = format_array(p);
assertEqual(out,'1 3 2 4')

function testDoubleInputWithPrecision
p = polysym(pi,1);
out = format_array(p);
assertEqual(out,'3.14159265358979');

function testPolysymInput
p = polysym(polysym('s'));
out = format_array(p);
assertEqual(out,'s');

function testCharInputWithScalarSize
p = polysym('x',[1 3]);
out = format_array(p);
assertEqual(out,'x1 x2 x3')

function testCharInputWithVectorSize
p = polysym('x',[2 2]);
out = format_array(p);
assertEqual(out,'x1_1 x2_1 x1_2 x2_2')

function testSquareRootMinusOne
p = polysym(sqrt(-1));
out = format_array(p);
assertEqual(out,'1*I')

function testImaginaryIntegerMultiplier
p = polysym(5*sqrt(-1));
out = format_array(p);
assertEqual(out,'5*I')

function testImaginaryIntegerMultiplierVector
p = polysym([3 4]*sqrt(-1));
out = format_array(p);
assertEqual(out,'3*I 4*I')

function testImaginaryRealMultiplier
r = pi*sqrt(-1);
p = polysym(r);
out = format_array(p);
precision = floor(log10(r/eps(r)));
assertEqual(out,[num2str(pi,precision),'*I'])

function testComplexInput
p = polysym(4+6i);
out = format_array(p);
assertEqual(out,'4+6*I')


