classdef test_read_raw_data < matlab.unittest.TestCase
    %Test the method for reading raw data
    
    properties
        poly_system
    end
    methods(TestMethodSetup)
        function nameFiles(testCase)
            BertiniClean
            
            polysyms('x','y')
            obj = BertiniLab('function_def',[x^2-1; x+y-1],'variable_group',[x y]);
            testCase.poly_system = solve(obj);
        end
    end
    
    methods(Test)
       
        function testNoFile(testCase)
            delete('raw_data')
            f = @() testCase.poly_system.read_raw_data;
            testCase.verifyError(f,'BertiniLab:read_raw_data:openError')
        end
        function testFileExists(testCase)
            isanint = @(x) round(x)==x;
            solution_info = testCase.poly_system.read_raw_data;
            testCase.verifyClass(solution_info,'struct')
            testCase.verifySize(solution_info,[1 2])
            testCase.verifyEqual([solution_info.path_number],[0 1])
            testCase.verifyTrue(isanint(solution_info(1).max_precision))
            testCase.verifyClass(solution_info(1).homogeneous_coordinates,'polysym')
            testCase.verifySize(solution_info(1).homogeneous_coordinates,[3 1])
            testCase.verifyTrue(isreal(solution_info(1).function_residual))
            testCase.verifyTrue(isreal(solution_info(1).condition_number))
            testCase.verifyTrue(isreal(solution_info(1).final_Newton_residual))
            testCase.verifyTrue(isreal(solution_info(1).final_pathvariable))
            testCase.verifyTrue(isreal(solution_info(1).lastdiff))
            testCase.verifyTrue(isanint(solution_info(1).pathvariable_of_first_precision_increase))
            testCase.verifyTrue(isanint(solution_info(1).endgame_cycle_number))
            testCase.verifyTrue(isanint(solution_info(1).path_flag))
        end
    end
    
    methods(TestMethodTeardown)
        function teardown(~)
            BertiniClean
        end
    end
end