classdef test_protected_properties < matlab.unittest.TestCase
    %Test the protected properties defined by BertiniLab
    
    properties
        classProperties
        pnames
    end
    methods(TestMethodSetup)
        function setup(testCase)
            mc = ?BertiniLab; % Create a metaclas
            
            % Now create structure with defaults for output information
            testCase.classProperties = mc.PropertyList; % Extract info on properties
            testCase.pnames = struct('solve_summary','');
        end
    end
    
    methods(Test)
        function testDefaults(testCase)
            pn = fieldnames(testCase.pnames);
            pvals = struct2cell(testCase.pnames);
            mp = testCase.classProperties;
            
            % Now check default for each argument
            for ii=1:length(pn)
                for jj=1:length(mp)
                    found = false;
                    if strcmp(mp(jj).Name,pn{ii})
                        found = true;
                        break
                    end
                end
                testCase.verifyTrue(found)
                testCase.verifyEqual(mp(jj).SetAccess,'protected')
                testCase.verifyTrue(mp(jj).HasDefault)
                testCase.verifyEqual(mp(jj).DefaultValue,pvals{ii})
            end
        end
    end
end