classdef test_membership < matlab.unittest.TestCase
    %Test the method for testing membership
    
    properties
        three_var_system
        member_point = {[2 2 0; 2 -2 0; -1 1 3], polysym([2 2 0; 2 -2 0; -1 1 3]), ...
            struct('x',[2 2 0],'y',[2 -2 0],'z',[-1 1 3])};
        not_member_point = {[1; 2; 3], polysym([1; 2; 3]), struct('x',1,'y',2,'z',3)};
    end
    methods(TestMethodSetup)
        function nameFiles(testCase)
            BertiniClean
            
            polysyms x y z
            p = BertiniLab('function_def',[x*z+y; y*z+x], ...
                'variable_group',[x y z]);
            testCase.three_var_system = p.irreducible_decomposition;
        end
    end
    
    methods(Test)
        function testNoArguments(testCase)
            f = @() testCase.three_var_system.membership;
            testCase.verifyError(f,'MATLAB:minrhs')
        end
        
        function testMember(testCase)
            % Order of components can vary, but membership matrix should be
            % a permutation of the unit matrix.
            for ii=1:numel(testCase.member_point)
                actual = testCase.three_var_system.membership(testCase.member_point{ii});
                testCase.verifyEqual(sum(actual),ones(1,3))
                testCase.verifyEqual(sum(actual,2),ones(3,1))
            end
        end
        
        function testNotMember(testCase)
            for ii=1:numel(testCase.not_member_point)
                actual = testCase.three_var_system.membership(testCase.not_member_point{ii});
                testCase.verifyEqual(actual,false(3,1))
            end
        end
        
        function testMultipleCodims(testCase)
            polysyms x y z
            S = x^2+y^2+z^2-1;
            T = y-x^2;
            U = z-x^3;
            p = BertiniLab('function_def',[T*S*(x-2); U*S*(y-2); T*U*S*(z-2)], ...
                'variable_group',[x y z]);
            p = p.irreducible_decomposition;
            
            % Find the isolated point, which is always the last component.
            actual = p.membership([2; 2; 2]);
            expected = [false(5,1); true];
            testCase.verifyEqual(actual,expected)
        end
    end
    
    methods(TestMethodTeardown)
        function teardown(~)
            BertiniClean
        end
    end
end