classdef test_make_interactive_choices < matlab.unittest.TestCase
    %Test the facilities for making interactive choices
    
    properties
        poly_system
        default_name
        user_name
    end
    methods(TestMethodSetup)
        
        function setup(testCase)
            testCase.poly_system = BertiniLab;
            testCase.default_name = 'interactive_choices';
            testCase.user_name = 'ic';
            warning('off','MATLAB:DELETE:FileNotFound')
            delete(testCase.default_name,testCase.user_name)
            warning('on','MATLAB:DELETE:FileNotFound')
        end
    end
    
    methods(Test)
        function testEmptyChoice(testCase)
            s = testCase.poly_system.make_interactive_choices;
            testCase.verifyTrue(isempty(s))
        end
        
        function testNameArgEmptyChoice(testCase)
            s = testCase.poly_system.make_interactive_choices;
            testCase.verifyTrue(isempty(s))
        end
        
        function testNotCell(testCase)
            testCase.poly_system.interactive_choices = 0;
            f = @() testCase.poly_system.make_interactive_choices;
            testCase.verifyError(f,'MATLAB:cellfun:NotACell')
        end
        
        function testDefaultName(testCase)
            testCase.poly_system.interactive_choices = {0};
            s = testCase.poly_system.make_interactive_choices;
            fname = testCase.default_name;
            testCase.verifyEqual(s,['< ',fullfile(pwd,fname)])
            testCase.verifyTrue(exist(fname,'file')==2)
            fid = fopen(fname);
            n = fscanf(fid,'%d\n');
            fclose(fid);
            testCase.verifyEqual(n,0)
        end
        
        function testNameArg(testCase)
            fname = testCase.user_name;
            testCase.poly_system.interactive_choices = {0};
            s = testCase.poly_system.make_interactive_choices(fname);
            testCase.verifyEqual(s,['< ',fullfile(pwd,fname)])
            testCase.verifyTrue(exist(fname,'file')==2)
            fid = fopen(fname);
            n = fscanf(fid,'%d\n');
            fclose(fid);
            testCase.verifyEqual(n,0)
        end
    end
    
    methods(TestMethodTeardown)
        function teardown(testCase)
            warning('off','MATLAB:DELETE:FileNotFound')
            delete(testCase.default_name,testCase.user_name)
            warning('on','MATLAB:DELETE:FileNotFound')
        end
    end
end
