classdef test_format_struct < matlab.unittest.TestCase
    %Test the static method for formatting structures
    
    methods(Test)
        
        function testEmptyStruct(testCase)
            out = BertiniLab.format_struct(struct([]));
            testCase.verifyEqual(out,{})
        end
        
        function testNumericalValue(testCase)
            out = BertiniLab.format_struct(struct('a',1));
            testCase.verifyEqual(out,{'a','1'})
        end
        
        function testPolysymValue(testCase)
            out = BertiniLab.format_struct(struct('a',polysym('1')));
            testCase.verifyEqual(out,{'a','1'})
        end
        
        function testPolysymRow(testCase)
            s = struct('variable_group',polysym({'x','y'}));
            out = BertiniLab.format_struct(s);
            testCase.verifyEqual(out,{'variable_group','x, y'})
        end
        
        function testPolysymColumn(testCase)
            s = struct('variable_group',polysym({'x';'y'}));
            out = BertiniLab.format_struct(s);
            testCase.verifyEqual(out,{'variable_group','x, y'})
        end
        
        function testCellstrRow(testCase)
            s = struct('variable_group',{{polysym('x'), polysym('y')}});
            out = BertiniLab.format_struct(s);
            testCase.verifyEqual(out,{'variable_group','x'; 'variable_group','y'})
        end
        
        function testCellstrColumn(testCase)
            s = struct('variable_group',{{polysym('x'); polysym('y')}});
            out = BertiniLab.format_struct(s);
            testCase.verifyEqual(out,{'variable_group','x'; 'variable_group','y'})
        end
        
        function testCellstrTwoD(testCase)
            s = struct('variable_group',{{polysym('x') polysym('y'); polysym('z') polysym('w')}});
            out = BertiniLab.format_struct(s);
            testCase.verifyEqual(out,{'variable_group','x'; 'variable_group','z'; ...
                'variable_group','y'; 'variable_group','w'})
        end
        
        function testInvalidType(testCase)
            f = @() BertiniLab.format_struct(struct('variable','x'));
            testCase.verifyError(f,'BertiniLab:format_struct:invalidType')
        end
    end
end