classdef test_constructor < matlab.unittest.TestCase
    %This suite tests all functions of the constructor that are not tested
    %separately for set/get methods.
    
    properties
        init_path
    end
    methods(TestMethodSetup)
        function nameFiles(testCase)
            testCase.init_path = getenv('PATH');
        end
    end
    methods(Test)
        function testNoArguments(testCase)
            out = BertiniLab;
            testCase.verifyTrue(isprop(out,'config'))
            testCase.verifyTrue(isprop(out,'function_def'))
            testCase.verifyTrue(isprop(out,'variable_group'))
            testCase.verifyTrue(isprop(out,'hom_variable_group'))
            testCase.verifyTrue(isprop(out,'pathvariable'))
            testCase.verifyTrue(isprop(out,'parameter'))
            testCase.verifyTrue(isprop(out,'constant'))
            testCase.verifyTrue(isprop(out,'subfunction'))
            testCase.verifyTrue(isprop(out,'solve_summary'))
            
            testCase.verifyEqual(out.config,struct)
            testCase.verifyEqual(out.function_def,polysym.empty)
            testCase.verifyEqual(out.variable_group,polysym.empty)
            testCase.verifyEqual(out.hom_variable_group,polysym.empty)
            testCase.verifyEqual(out.pathvariable,polysym.empty)
            testCase.verifyEqual(out.parameter,polysym.empty(0,2))
            testCase.verifyEqual(out.constant,polysym.empty(0,2))
            testCase.verifyEqual(out.subfunction,polysym.empty(0,2))
            testCase.verifyEqual(out.solve_summary,'')
        end
        function testSingleArgument(testCase)
            f = @() BertiniLab('config');
            testCase.assertError(f,'BertiniLab:Constructor:notPaired')
        end
        function testsThreeArgs(testCase)
            f = @() BertiniLab('variable_group',polysym({'x','0'}),'variable_group');
            testCase.assertError(f,'BertiniLab:Constructor:notPaired')
        end
        function testRedundantAssignment(testCase)
            out = BertiniLab('variable_group',polysym({'x','0'}), ...
                'variable_group',polysym({'x','1'}));
            testCase.verifyEqual(out.variable_group,polysym({'x','1'}))
        end
        function testSameAsSet(testCase)
            out1 = BertiniLab('variable_group',polysym({'x','1'}));
            out2 = BertiniLab;
            out2.variable_group = polysym({'x','1'});
            testCase.verifyEqual(out1,out2)
        end
        function testSetProtected(testCase)
            out = BertiniLab('solve_summary',3);
            testCase.verifyEqual(out.solve_summary,3)
        end
        function testBertiniProperty_PC(testCase)
            testCase.assumeTrue(ispc)
            p = BertiniLab;
            setenv('PATH',[p.program_folder,';',testCase.init_path])
            testCase.assumeTrue(exist(p.program_name,'file')==2)
            testCase.verifyEqual(p.bertini,p.program_name)
        end
        function testBertiniProperty_Unix(testCase)
            testCase.assumeFalse(ispc)
            p = BertiniLab;
            setenv('PATH',[p.program_folder,':',testCase.init_path])
            testCase.assumeTrue(exist(p.program_name,'file')==2)
            testCase.verifyEqual(p.bertini,p.program_name)
        end
    end
    methods(TestMethodTeardown)
        function teardown(testCase)
            setenv('PATH',testCase.init_path)
        end
    end
end