classdef test_addpath_system < matlab.unittest.TestCase
    %Test the static method addpath_system
    %
    % Some of the tests apply to Unix systems and some to PC's; the
    % assumption statements ensure that any tests for the wrong system are
    % returned incomplete.
    
    properties
        init_path
    end
    methods(TestMethodSetup)
        function nameFiles(testCase)
            testCase.init_path = getenv('PATH');
        end
    end
    
    methods(Test)
        function testNewName_Unix(testCase)
            testCase.assumeFalse(ispc)
            new_folder = '/tmp/dummy_dir';
            testCase.assumeEmpty(strfind(new_folder,getenv('PATH')))
            
            final_path_name = BertiniLab.addpath_system(new_folder);
            expected_path_name = [new_folder,':',testCase.init_path];
            testCase.verifyEqual(final_path_name,expected_path_name)
        end
        function testNewName_PC(testCase)
            testCase.assumeTrue(ispc)
            new_folder = 'C:\Program Files\dummydir';
            testCase.assumeEmpty(strfind(new_folder,getenv('PATH')))
            
            final_path_name = BertiniLab.addpath_system(new_folder);
            expected_path_name = [new_folder,';',testCase.init_path];
            testCase.verifyEqual(final_path_name,expected_path_name)
        end
        function testExistingName_Unix(testCase)
            testCase.assumeFalse(ispc)
            idx = find(testCase.init_path==':',1,'first');
            new_folder = testCase.init_path(1:idx-1);
            testCase.assumeNotEmpty(strfind(getenv('PATH'),new_folder))
            final_path_name = BertiniLab.addpath_system(new_folder);
            testCase.verifyEqual(final_path_name,testCase.init_path)
        end
        function testExistingName_PC(testCase)
            testCase.assumeTrue(ispc)
            idx = find(testCase.init_path==';',1,'first');
            new_folder = testCase.init_path(1:idx-1);
            testCase.assumeNotEmpty(strfind(getenv('PATH'),new_folder))
            final_path_name = BertiniLab.addpath_system(new_folder);
            testCase.verifyEqual(final_path_name,testCase.init_path)
        end
    end
    methods(TestMethodTeardown)
        function teardown(testCase)
            setenv('PATH',testCase.init_path)
        end
    end
end