function install
%INSTALL Install BertiniLab
%
% install adds the current folder to the MATLAB path and returns an
% instruction to add a string to the startup.m file so the path can be
% modified automatically when MATLAB is started.

fprintf('\n   BertiniLab version %s\n\n',BertiniLabVersion)

% Create a string to add to the startup file
addpath(genpath(BertiniLabRoot));
rmpath(genpath(fullfile(BertiniLabRoot,'tests')))

% Build the search database for the documentation
builddocsearchdb(fullfile(BertiniLabRoot,'doc','html'))
disp(' ')

disp('Remaining actions needed:')
disp(' ')
disp('1. Add these lines to your startup folder:')
disp(['addpath(genpath(''',BertiniLabRoot,''')); rmpath(genpath(''',fullfile(BertiniLabRoot,'tests'),'''));'])
disp(' ')
disp('2. Install Bertini (see GettingStartedWithBertiniLab.html)')
disp(' ')
disp('3. Edit the definition of program_folder in @BertiniLab/BertiniLab.m to give the folder where Bertini resides.')
disp(' ')
disp('4. Edit the definition of program_name in @BertiniLab/BertiniLab.m to give the name that is used to call Bertini.')

