function publishBookExamples(docName)
%PUBLISHBOOKEXAMPLES Publish examples in MATLAB documentation style

if nargin < 1
    decision = input('Some of these files take several minutes to publish! Continue? [Y/N]', ...
        's');
    if ~strcmpi(decision,'Y')
        disp('Exiting. You can publish a single file using publishBookExamples(filename).')
        return
    end
    
    docName = {'Intersections_of_straight_lines.m', ...
        'Intersection_of_circle_with_y_axis.m','Numerical_accuracy_and_function_residuals.m', ...
        'Straight_line_programs.m', ...
        'User_defined_homotopy_1.m', 'User_defined_homotopy_2.m', ...
        'Simple_eigenvalue_problem.m','Generalized_eigenvalue_problem.m', ...
        'Paths_to_infinity.m', ...
        'Multihomogeneous_homotopy.m', ...
        'Intersection_of_two_spheres_and_a_cone_using_regeneration.m','Lagrange_points.m', ...
        'Parameter_homotopy_Sextic_Ab_Initio.m', ...
        'Sharpening_using_Newtons_method.m','Sharpening_module.m', ...
        'Root_sharpening_after_a_homotopy.m','Evaluating_a_system_and_Jacobian.m', ...
        'Performing_a_Newton_iteration.m', ...
        'Witness_sets_and_the_numerical_irreducible_decomposition', ...
        'Complete_intersection.m','Incomplete_intersection.m', ...
        'Adjacent_Minors_dimension_by_dimension.m', ...
        'Printing_a_Witness_Set.m', ...
        'Intersection_of_two_lines.m', ...
        'Point_on_each_connected_component.m'};
    
elseif ischar(docName)
    docName = {docName};
end

docFolder = fullfile(BertiniLabRoot,'doc');
options_doc_BertiniLab.stylesheet = fullfile(docFolder,'mxdom2mathjax.xsl');

for ii=1:length(docName)
    disp(['Publishing ',docName{ii}])
    publish(docName{ii},options_doc_BertiniLab);
end

% Clean up Bertini files
BertiniClean