%% Witness sets and the numerical irreducible decomposition
% Example 8.11 from _Numerically solving polynomial systems
% with Bertini_, by Daniel J. Bates, Jonathan D. Haunstein, Andrew J.
% Sommese and Charles W. Wampler (SIAM 2013).
%
% We wish to solve the system of polynomial equations
%
% $$ (y-x^2)(x^2+y^2+z^2-1)(x-2) = 0 $$
%
% $$ (z-x^3)(x^2+y^2+z^2-1)(y-2) = 0 $$
%
% $$ (z-x^3)(y-x^2)(x^2+y^2+z^2-1)(z-2) = 0. $$
%
% The complex solution of this system consists of a surface
% ($x^2+y^2+z^2=1$), the tangent bundle to a sphere in complex space; three
% lines ($x=2$ and $z=8$ with $y$ free; $y=2$ and $x=\pm\sqrt{2}$ with $z$
% free); one nonlinear curve ($y=x^2$ and $z=x^3$) and an isolated point
% $(2,2,2)$. To find these solutions (called an irreducible decomposition),
% Bertini uses witness sets (see the book for details).

polysyms x y z
S = x^2+y^2+z^2-1;
T = y-x^2;
U = z-x^3;
poly_system = BertiniLab('function_def',[T*S*(x-2); U*S*(y-2); T*U*S*(z-2)], ...
    'variable_group',[x y z]);
poly_system = poly_system.irreducible_decomposition;

results = poly_system.solve_summary;
istart = strfind(results,'************** Decomposition by Degree');
disp(results(istart:end))

%%
% The surface has degree 2 and dimension 2; the nonlinear curve has degree 1
% and dimension 3.
%
% Components can be sampled using the method |sample|:
component = struct('dim',2,'component_number',0);
points_on_sphere = poly_system.sample(component,100,'sphere_sample');
disp(points_on_sphere)