%% A user-defined homotopy (version 2)
% Section 2.3  from _Numerically solving polynomial systems
% with Bertini_, by Daniel J. Bates, Jonathan D. Haunstein, Andrew J.
% Sommese and Charles W. Wampler (SIAM 2013).
%
% Traces the path around a circle. Uses a variable, parameters and a
% subfunction.
%
% In this version of the example, we use only one parameter in place of the
% two parameters of the previous example. This parameterizes the same path
% as in version 1, ending at the same point.

polysyms z H Pi t s;

config = struct('USERHOMOTOPY',1);
sval = cos(2*Pi*(1-t)) + 1i*sin(2*Pi*(1-t));

poly_system = BertiniLab('config',config,'function_def',z^2-s,'function_name',H, ...
    'variable',z,'pathvariable',t,'parameter',[s sval],'starting_points',1);
poly_system = solve(poly_system);
sols = poly_system.match_solutions('raw_solutions');
zsols = double(sols.z);
fprintf('%15.11f + %15.11fi\n',[real(zsols) imag(zsols)].')
