%% A user-defined homotopy (version 1)
% Section 2.3 from _Numerically solving polynomial systems
% with Bertini_, by Daniel J. Bates, Jonathan D. Haunstein, Andrew J.
% Sommese and Charles W. Wampler (SIAM 2013).
%
% Traces a single solution path of 
% 
% $$H(z,s) = z^2 - s$$
% 
% as $s$ goes clockwise around the unit circle starting at $s=1$.
% Uses a variable, parameters and a subfunction.
%
% Because of the restrictions on Bertini syntax, the pathvariable cannot
% be used directly in the function expression.

polysyms z H Pi t s
config = struct('UserHomotopy',1); % User-defined homotopy
q = polysym('q',[2 1]);
qvals = [cos(2*Pi*(1-t)); sin(2*Pi*(1-t))];

poly_system = BertiniLab('config',config,'function_def',z^2-s,'function_name',H, ...
    'variable',z,'pathvariable',t,'parameter',[q qvals],'subfunction', ...
    [s q(1)+1i*q(2)],'starting_points',1);
poly_system = solve(poly_system);
sols = poly_system.match_solutions('raw_solutions');
zsols = double(sols.z);
fprintf('%15.11f + %15.11fi\n',[real(zsols) imag(zsols)].')

%%
% As expected, there is a single endpoint, z=-1.
