%% Straight-line programs
% Section 1.1.5 from _Numerically solving polynomial systems
% with Bertini_, by Daniel J. Bates, Jonathan D. Haunstein, Andrew J.
% Sommese and Charles W. Wampler (SIAM 2013).
%
% Subfunctions can be defined in Bertini to simplify expressions, as in
% this example:

polysyms z a b p
poly_system = BertiniLab('variable_group',z,'subfunction',[a z^3+z+1; b z^2+2],...
    'function_def',a^4-5*b^3+6);
poly_system = solve(poly_system);

results = poly_system.solve_summary;
istart = strfind(results,'Finite Solution');
disp(results(istart:end))