%% A simple eigenvalue problem
% Section 4.1 from _Numerically solving polynomial systems with Bertini_,
% by Daniel J. Bates, Jonathan D. Haunstein, Andrew J. Sommese and Charles
% W. Wampler (SIAM 2013).
%
% Solve the eigenvalue problem
%
% $$A v = \lambda v. $$
%
% The resulting equations are homogeneous in the components of the vector
% $v$. In the book, the equations are written down explicitly, but here we
% use matrix algebra, which is easily generalized to different numbers of
% dimensions.

polysyms lambda;
v = polysym('v',[1 2]);
A = [1 2; 3 4];

poly_system = BertiniLab('function_def',A*v.'-lambda*v.','variable_group',lambda, ...
    'hom_variable_group',v);
poly_system = solve(poly_system);

%%
% The solutions are classified as real, so they can be found in the file
% |real_finite_solutions|.
sols = poly_system.match_solutions('real_finite_solutions',lambda,v);
disp('Eigenvalues:')
fprintf('%15.11f %15.11f\n',double(sols.lambda))
disp('Eigenvector matrix:')
fprintf('%15.11f %15.11f\n',double(sols.v.'))
