%% Root sharpening after a homotopy
% Section 7.2 from _Numerically solving polynomial systems with Bertini_,
% by Daniel J. Bates, Jonathan D. Haunstein, and Andrew J. Sommese and
% Charles W. Wampler (SIAM 2013).
%
% Our goal is to find the intersection of a hyperbola and parabola:
%
% $$ x^2+y^2=1, \quad x=y^2+1. $$
%
% The solutions are two nonsingular points $\left(0,\pm\sqrt{-1}\right)$
% and a point $(1,0)$ of multiplicity 2.

polysyms x y
hyperbola = x^2 - y^2 - 1;
parabola = x - y^2 - 1;

poly_system = BertiniLab('function_def',[hyperbola; parabola],'variable_group',[x y]);
poly_system = solve(poly_system);
sols = poly_system.match_solutions('nonsingular_solutions');

%%
% The solutions approximating $(0,\pm i)$ are shown below:
disp([x y; sols.x(:) sols.y(:)])

%%
% Now sharpen to 20 digits (which we expect to fail for the singular
% solution). This can be done with the method |sharpen|:
poly_system.config.SharpenDigits = 20;
poly_system = poly_system.sharpen;

%%
% For comparison, here are the revised values of the two solutions:
sols = poly_system.match_solutions('nonsingular_solutions');
disp([x y; sols.x(:) sols.y(:)])

%%
% The result is much closer to the correct value of zero, but the singular
% solutions are not successfully sharpened:
result = poly_system.solve_summary;
istart = strfind(result,'Endpoints Considered');
disp(result(istart:end))

%%
% To sharpen the singular solution, the endgame must be chosen instead of
% Newton's method. This is done by providing an options structure to
% |sharpen|:
opts = struct('sharpening_method','endgame');
poly_system = poly_system.sharpen(opts);

result = poly_system.solve_summary;
istart = strfind(result,'Endpoints Considered');
disp(result(istart:end))
