%% A point on each connected component
%
% We wish to find the decomposition of the real solutions of the sextic
% plane curve:
%
% $$ x_2^2 + x_1^2(x_1-1)^3(x_1-2). $$
%
% We begin by solving the Fritz John homotopy (see Section 14.4):

polysyms x1 x2 l0 l1
y1 = 0.5;
y2 = 0.8;
eps = 1.1 + 0.7i;
a0 = -1.3;
a1 = 1.7;

F = x2^2 + x1^2*(x1-1)^3*(x1-2) - eps;
G1 = l0*(x1-y1) + l1*x1*(x1-1)^2*(6*x1^2-13*x1+4);
G2 = l0*(x2-y2) + 2*l1*x2;
patch = a0*l0 + a1*l1 - 1;
poly_system = BertiniLab('variable_group',{[x1 x2],[l0 l1]}, ...
    'function_def',[F; G1; G2; patch],'config',struct('SecurityLevel',1));

poly_system = solve(poly_system);
results = poly_system.solve_summary;
istart = strfind(results,'NOTE: nonsingular');
iend = strfind(results,'The following files');
disp(results(istart:iend-1))

%%
% There should be 16 finite solutions. We use these as the starting point
% for a user homotopy:
polysyms t T

F = x2^2 + x1^2*(x1-1)^3*(x1-2) - t*eps;
poly_system.function_def = [F; G1; G2; patch];

poly_system.config.UserHomotopy = 2;
poly_system.pathvariable = T;
poly_system.parameter = [t T];

poly_system.starting_points = poly_system.read_solutions('finite_solutions');

poly_system = solve(poly_system);
results = poly_system.solve_summary;
istart = strfind(results,'NOTE: nonsingular');
iend = strfind(results,'The following files');
disp(results(istart:iend-1))

%%
% There are three real roots, one each with multiplicity 1, 2 and 3:
sols = poly_system.match_solutions('real_finite_solutions');
real(double([sols.x]))