%% Intersection of two lines
% Example 12.1 from _Numerically solving polynomial systems
% with Bertini_, by Daniel J. Bates, Jonathan D. Haunstein, Andrew J.
% Sommese and Charles W. Wampler (SIAM 2013).
%
% We will look for the intersection of two algebraic sets A and B with
% witness sets $W_A = \{F_A,L_A,S_A\}$ and $W_B = \{F_B,L_B,S_B\}$, where
%
% $$ F_A(x_1,x_2) = x_1 \quad F_B(x_1,x_2) = x_1x_2 $$
%
% $$ L_A(x_1,x_2) = 2x_1+x_2-2 \quad L_B(x_1,x_2) = x_1+3x_2+4 $$
%
% $$ S_A = \{(0,2)\} \quad S_B = \{(-4,0)\}. $$
%
% This can be done with a user-defined homotopy, as described in the book.

polysyms x1 x2 y1 y2 T t gamma
FA = x1;
FB = y1*y2;
L1 = gamma*t*(2*x1 + x2 - 2) + (1-t)*(x1 - y1);
L2 = gamma*t*(x1 + 3*y2 + 4) + (1-t)*(x2 - y2);

poly_system = BertiniLab('variable_group',[x1 x2 y1 y2],'function_def',[FA; FB; L1; L2], ...
    'config',struct('UserHomotopy',2),'pathvariable',T,'parameter',[t T], ...
    'random',gamma,'starting_points',[0; 2; -4; 0]); %[[x1; x2; y1; y2],polysym([0; 2; -4; 0])]);


poly_system = poly_system.solve;
sols = poly_system.match_solutions('finite_solutions');
disp([sols.x; sols.y].')
