%% Evaluating a system and Jacobian
% Section 7.3.1 from _Numerically solving polynomial systems with Bertini_,
% by Daniel J. Bates, Jonathan D. Haunstein, Andrew J. Sommese and Charles
% W. Wampler (SIAM 2013).
%
% Bertini can be asked to evaluate a system of polynomials and, optionally,
% its Jacobian. BertiniLab provides the method |evaluate| as an interface.
% Below, this method is applied to the intersection of a circle and its
% parabola, a system that was already solved in "Sharpening using Newton's
% method".
%
% A start file must be provided with the points, which in this example are
% $(3/4,2)$ and $(10^{-15},1/4)$.

load circle_parabola_intersection
circle_parabola_intersection.config = struct('MPType',1,'Precision',64);
points.x = [.75 1e-15];
points.y = [2 .25];
[fvals,J] = circle_parabola_intersection.evaluate(points);

%%
% Here are the values at the two points (a column for each point):
fprintf('%15.11g %15.11g\n',double(fvals).')

%%
% The Jacobians are returned as a cell array with one element per point.
% Here is the first point:
disp(double(J{1}))

%%
% Note that in the files returned by Bertini, matrix elements are presented
% in row-major ordering.
