% EXAMPLES from "Numerically solving polynomial systems with Bertini"
% by Daniel J. Bates, Jonathan D. Haunstein, Andrew J. Sommese and Charles
% W. Wampler (SIAM 2013).
%
% Examples from Chapter 1: Polynomial Systems
%   Intersections_of_straight_lines                           - Intersections of straight lines
%   Numerical_accuracy_and_function_residuals                 - Numerical accuracy and function residuals
%   Intersection_of_circle_with_y_axis                        - Intersection of circle with |y| axis
%   Straight_line_programs                                    - Straight-line programs
%
% Examples from Chapter 2: Basic Polynomial Continuation
%   User_defined_homotopy_1                                   - A user-defined homotopy (version 1)
%   User_defined_homotopy_2                                   - A user-defined homotopy (version 2)
%
% Examples from Chapter 4: Projective Space
%   Simple_eigenvalue_problem                                 - A simple eigenvalue problem
%   Generalized_eigenvalue_problem                            - Generalized eigenvalue problem
%   Paths_to_infinity                                         - Paths to infinity
%
% Examples from Chapter 5: Types of Homotopy
%   Multihomogeneous_homotopy                                 - Multihomogeneous homotopy
%   Intersection_of_two_spheres_and_a_cone_using_regeneration - Intersection of two spheres and a cone using regeneration
%   Lagrange_points                                           - Lagrange points
%
% Examples from Chapter 6: Parameter Homotopies
%   Parameter_homotopy_Sextic_Ab_Initio                       - Parameter homotopy: Sextic Ab Initio
%
% Examples from Chapter 7: Advanced Topics Connected with Isolated Solutions
%   Sharpening_module                                         - Sharpening module
%   Sharpening_using_Newtons_method                           - Sharpening using Newton's method
%   Root_sharpening_after_a_homotopy                          - Root sharpening after a homotopy
%   Evaluating_a_system_and_Jacobian                          - Evaluating a system and Jacobian
%   Performing_a_Newton_iteration                             - Performing a Newton iteration
%
% Examples from Chapter 8: Positive-Dimensional Components
%   Witness_sets_and_the_numerical_irreducible_decomposition  - Witness sets and the numerical irreducible decomposition
%   A_simpler_positive_dimensional_example                    - A simpler positive-dimensional example
%
% Examples for Chapter 9: Computing Witness Supersets
%   Complete_intersection                                     - Complete intersection
%   Incomplete_intersection                                   - Incomplete intersection
%   Adjacent_Minors_dimension_by_dimension                    - Adjacent Minors: dimension-by-dimension
%
% Examples for Chapter 11: Advanced Topics Connected With Positive-Dimensional Solution Sets
%   Printing_a_Witness_Set                                    - Printing a Witness Set
%
% Examples for Chapter 12: Intersection
%   Intersection_of_two_lines                                 - Intersection of two lines
%
% Examples from Chapter 14: Real Solutions
%   Point_on_each_connected_component                         - A point on each connected component
%
% Other files
%   publishBookExamples                                       - Publish examples in MATLAB documentation style
