%% Adjacent Minors: dimension-by-dimension
% Example 9.3 from _Numerically solving polynomial systems with Bertini_,
% by Daniel J. Bates, Jonathan D. Haunstein, Andrew J. Sommese and Charles
% W. Wampler (SIAM 2013).
%
% This polynomial system is the set of 2x2 minors of a 2x4 matrix of
% variables.  The next three examples are just different ways of running
% this same problem.  Notice the difference in time.
x = polysym('x',[3 4]);
f = [x(1,1:3).*x(2,2:4) - x(1,2:4).*x(2,1:3) x(2,1:3).*x(3,2:4) - x(2,2:4).*x(3,1:3)].';
config = struct('WitnessGenType',1, ...      % dimension-by-dimension
                'WitnessSupersetOnly',1);    % only compute a witness point superset

poly_system = BertiniLab('variable_group',x,'function_def',f,'config',config);
poly_system = poly_system.irreducible_decomposition;

results = poly_system.solve_summary;
istart = strfind(results,'NOTE: nonsingular');
disp(results(istart:end))

%% Adjacent minors: classical cascade mode
poly_system.config.WitnessGenType = 0;
poly_system = poly_system.irreducible_decomposition;

results = poly_system.solve_summary;
istart = strfind(results,'NOTE: nonsingular');
disp(results(istart:end))


%% Adjacent minors: regeneration
poly_system.config.WitnessGenType = 2;
poly_system = poly_system.irreducible_decomposition;

results = poly_system.solve_summary;
istart = strfind(results,'NOTE: nonsingular');
disp(results(istart:end))

%%
% A run with |WitnessSupersetOnly| set to zero shows that the solution set
% consists of 6 irreducible components of various dimensions and degrees:
poly_system.config.WitnessSupersetOnly = 0;
poly_system = poly_system.irreducible_decomposition;
results = poly_system.solve_summary;
istart = strfind(results,'************** Decomposition');
disp(results(istart:end))
