%% A simpler positive-dimensional example
% Example 8.12 from _Numerically solving polynomial systems
% with Bertini_, by Daniel J. Bates, Jonathan D. Haunstein, Andrew J.
% Sommese and Charles W. Wampler (SIAM 2013).
%
% We wish to solve the system of polynomial equations
%
% $$ x*z + y = 0 $$
%
% $$ y*z + x = 0. $$
%
% The irreducible solution set for this system is three lines: one with 
% $x = y = 0$ and $z$ free, one with $x = y$ (nonzero) and $z = -1$; and one
% with $x = -y$ (nonzero) and $z = 1$.

polysyms x y z
poly_system = BertiniLab('function_def',[x*z+y; y*z+x], ...
    'variable_group',[x y z]);
poly_system = poly_system.irreducible_decomposition;

results = poly_system.solve_summary;
istart = strfind(results,'************** Decomposition by Degree');
disp(results(istart:end))

%%
% We can test each of the proposed solutions for membership. The method
% |membership| returns a logical array with a column for each point and a
% row for each component. An element is true if the point is a member of
% that component. The order of components varies, but if we input a point
% from each of the three solutions, we will get a permutation of the
% identity matrix.
membership_info = poly_system.membership([0 0 pi; 2 2 -1; 2 -2 1].');
disp(membership_info)
