%% What is Bertini?
%
% Bertini is a general-purpose solver for research on polynomial
% continuation. It solves systems of polynomial equations using homotopy
% continuation.
%
% Bertini was written in the C language by Daniel J. Bates, Jonathan D.
% Hauenstein, Andrew J. Sommese, and Charles W. Wampler. It is distributed
% free of charge with no warranties, implied or otherwise, that it is
% suitable for any purpose. Its intended usage is educational, so that the
% user may gain a greater understanding of numerical homotopy continuation
% for solving systems of polynomial equations. Any other use is strictly
% the user's responsibility.
%
% *Key features*
%
% * Finds isolated solutions using total-degree start systems,
% multihomogeneous-degree start systems, and also user defined homotopies.
% * Implements parameter continuation for families of systems, such as the
% inverse kinematics of six-revolute serial-link arms, or the forward
% kinematics of Stewart-Gough parallel-link robots.
% * Adaptive multiprecision implemented for finding isolated solutions and
% for the numerical irreducible decomposition.
% * Treats positive-dimensional solutions by computing witness sets.
% * Has automatic differentiation which preserves the straightline quality
% of an input system.
% * Uses homogenization to accurately compute solutions "at infinity."
% * Provides endgames to accurately compute singular roots.
% * Allows for subfunctions.
% * Allows for witness set manipulation via both sampling and membership
% testing.
% * Accepts underdetermined, exactly determined, and overdetermined systems
% (i.e., the number of variables and equations do not have to be equal).
