%% BertiniLab Release Notes

%% Version 1.5
% class BertiniLab:
%
% * fixed bugs: 
%
%     * read methods looked for a file in the entire MATLAB path if it didn't find it in io_folder.
%     * mat2struct handled column vectors incorrectly.
% 
% * added properties:
%
%     * components - information on components of an algebraic set
%     * witness_points - witness points of algebraic set components (dependent)
% 
% * changed properties:
%
%     * order_of_variables - now a dependent property
% 
% * added methods:
%
%     * dehomogenize - converts homogeneous coordinates to affine
%     * evaluate - evaluate a polynomial system (and, optionally, its Jacobian)
%     * irreducible_decomposition - Find irreducible decomposition
%     * membership - test membership of a point in the algebraic components
%     * Newton_iteration - perform Newton iteration on a system
%     * read_incidence_matrix - read membership information
%     * read_witness_data - read witness data file
%     * sample - sample an algebraic component
%     * sharpen - sharpen an isolated point solution
% 
% * removed methods:
%
%     * set_order_of_variables removed; property order_of_variables now dependent
% 
% * modified methods:
%
%     * unpack_solutions renamed struct2mat
%     * match_solutions dehomogenizes data
% 
% * documentation:
%
%     * renamed GettingStarted.m to GettingStartedWithBertiniLab.m to avoid
%             possible shadowing problems
%     * moved release notes into documentation
%     * can now access examples using 'demo toolbox BertiniLab'
%     * updates search database after every change
% 
% class polysym:
%
%     * added method polyval
% 
%% Version 1.4
% class BertiniLab:
%
% * Added hidden property 'program_folder' and methods 'bertiniVersion' 
%         and 'addpath_system'. These allow BertiniLab to handle spaces 
%         in path name for bertini.
% * Displays version info for bertini on first call
% * Fixed a bug in method unpack_solutions: did not handle vectors correctly
% 
% class polysym:
%
% * Backward compatible to R2010 now
% 
% other:
%
% * Can use 'ver' command to get BertiniLab version number
% * Added 'install' command to set up path and create utilities BertiniLabRoot
%         and BertiniLabVersion.
% 
%% Version 1.3
% class BertiniLab:
%
% * Changed use of I/O folder to avoid using full path names (problems
%         occur if the folder names have blanks in them)
% * Separated function name from function values
% 
% class polysym:
%
% * Fixed bug in horzcat and vertcat
% * Allow multidimensional arrays
% 
% tests:
%
% * Converted tests to use builtin MATLAB test framework
% * Tested on R2014a
% 
% utilities:
%
% * Created BertiniClean to remove Bertini-created files
% 
% doc:
%
% * Added instructions on Windows installation and choosing an I/O folder
% * Bertini-created files removed after docs are published
% 
%% Version 1.2
% class BertiniLab:
%
% * Allows user to set folder for I/O
% * Allows membership testing
% * Default input file name now 'input'
% * More useful error message if function_def has too many columns
% * Fixed bug in set methods for variable_group and hom_variable_group
% * Numeric inputs now allowed for interactive session
% 
% class polysym:
%
% * Bug in format_array fixed (couldn't display empty polysym object)
% * Constructor now preserves dimensions of empty arrays
% * Replaced format_with_commas with the more general format_array
% * Improved tools for grouping arrays of variable names: 
%         char_base and common_name replaced root_name; also put_in_arrays
% 
% examples:
%
% * More extended collection of examples from book organized by chapter
% 
% doc:
%
% * First_run added, linked from GettingStarted
% 
%% Version 1.1
% class BertiniLab:
%
% * Added support for parameter homotopy (Bertini version)
%     * property final_parameters and method make_final_parameter_file added
%     * property parameters can now have a single column
% * Revised I/O routines to work in full precision (polysym objects instead of numeric)
%     * methods read_raw_data, read_solutions, print_declarations, make_input_file, match_solutions
% * Changed make_start_file to use new property starting_points
% * Added property interactive_choices and changed make_interactive_choices to use it instead of function arguments
% 
% class polysym:
%
% * Added routines to handle numbers without converting to numeric class: 
%       	      find_real_numbers, find_imag_numbers, real_imag
% * Changed behavior of isempty, isone, iszero, mtimes
% * Added horzcat and vertcat to get more intuitive combining of arrays
% * Changed display to one without quotes around array components
% * Added more flexible formatting routine format_array
% * Default value for polysym is now zero
% * Empty argument to polysym now returns empty polysym array
% * Added information on conversion methods to manual
