%% Known issues

%% Inconsistencies between symbolic engines

%%
% Vector handling
% The result of these commands depends on the symbolic engine. In R2012b
% with Maple as the symbolic engine, |y| is a column vector. In R2013a and
% later with MuPAD, |y| is a row vector.
x = polysym('(1+sqrt(5))/2');
x = [x x*1i];
y = vpa(x);
disp(y)

%%
% Precision
% The conversion between types is handled differently by the two symbolic
% engines. Below, |x| and |x(1)| are the same for the Maple engine and
% different for the MuPAD engine. In the latter, |x(1)| gets the number of
% digits determined by <matlab:doc('digits') digits>, not the number of
% digits in |x|.
digits(32)
x = vpa(pi,40);
disp(x)
disp(x(1))

%%
% We have designed |polysym| to use |digits| for the precision:
disp(polysym(x))

%% Deletion of files (Windows 7)
% In Windows 7, a file delete command (in, say, |BertiniClean|) may result
% in the error: |Warning: File not found or permission denied|. Try
% deleting the same file manually. If the result is the error, |The action
% can't be completed because the folder or a file in it is open in another
% program|, you may have a thumbnail caching issue. See
% <www.kishmish.com/kb/article.php&id=17> for one fix. Unfortunately, it
% only works in business or pro versions of Windows 7.