function R = vpa(p,d)
%VPA Variable-precision arithmetic
%
% R = vpa(p) inputs a polysym array and converts it to variable-precision
% arithmetic. Returns an error if any element is not a valid number.
%
% R = vpa(p,d) uses at least D significant (nonzero) digits instead of the
% current setting of DIGITS.
%
% Example:
%   p = polysym('pi + 2.5*I');
%   vpa(p,40)

if nargin < 2
    d = digits;
end

% Convert to SYM and then use builtin vpa
R = vpa(sym(p),d);
