function obj2 = uminus(obj1)
% Overloaded unary minus (-) function
%
% OBJ2=UMINUS(obj1) inputs an array of POLYSYM objects and returns
% another in which OBJ2(i) = -OBJ1(i).
%
% Example:
%  s = polysym({'s'});
%  disp(-s)
%
% See also MINUS.

obj2 = obj1;
for k=1:numel(obj1)
    if ~isequal(obj1.Value,'[]') && ~iszero(obj1(k))
        obj2(k).Value = ['-',checkParens(obj1(k))];
    end
end
