function L = triu(X,varargin)
%TRIU Upper triangular part of matrix
%
% L = triu(X) returns the upper triangular part of X.
% L = triu(X,k) returns the elements on and above the kth diagonal of X.
%
% k=0 gives the main diagonal, k<0 is below and k>0 is above.
%
% See also: diag, tril

L = polysym(zeros(size(X)));
idx = triu(true(size(X)),varargin{:});
L(idx) = X(idx);