function L = tril(X,varargin)
%TRIL Lower triangular part of matrix
%
% L = tril(X) returns the lower triangular part of X.
% L = tril(X,k) returns the elements on and below the kth diagonal of X.
%
% k=0 gives the main diagonal, k<0 is below and k>0 is above.
%
% See also: diag, triu

L = polysym(zeros(size(X)));
idx = tril(true(size(X)),varargin{:});
L(idx) = X(idx);