function obj = times(obj1,obj2)
% Overloaded element-by-element multiplication (.*) function
%
% OBJ=MTIMES(OBJ1,OBJ2) inputs two arrays of POLYSYM objects and returns
% their element-by-element product OBJ1.*OBJ2.
%
% Example:
%  s = polysym({'a','b'; 'c','d'});
%  t = polysym({'p','q'; 'r','s'});
%  disp(s*t)
%   'a*p'    'b*q'
%   'c*r'    'd*s'
%
% See also MTIMES.

obj1 = polysym(obj1); obj2 = polysym(obj2);
[obj1,obj2] = makeSameSize(obj1,obj2);

obj = obj1;
for k=1:numel(obj)
    if iszero(obj2(k)) || iszero(obj1(k))
        obj(k) = polysym('0');
    elseif isone(obj1(k))
        obj(k).Value = obj2(k).Value;
    elseif ~isone(obj2(k))
        s1 = checkParens(obj1(k));
        s2 = checkParens(obj2(k));
        obj(k).Value = regexprep([s1,'*',s2],'\*\s*1\s*\*','*'); % Remove '*1*'
    end
end
end% times
