function obj = sin(obj)
% Overloaded sine function
%
% obj = sin(obj) inputs an array of POLYSYM objects and returns their sines.
%
%
% Generally these are just strings, e.g., 'sin(x)'. However, the sine
% of zero is returned as 0.
%
% Example:
%   polysyms x
%   sin(x)
%
% See also COS, EXP.

for k=1:numel(obj)
    if iszero(obj(k))
        obj(k).Value = '0';
    else
        obj(k).Value = ['sin(',obj(k).Value,')'];
    end
end