function obj2 = prod(obj,dim)
%PROD Overloaded product of elements.
%  
%   obj2 = prod(obj) inputs OBJ, a POLYSYM array, and returns OBJ2, the
%   product along one of its dimensions.
%
%   If OBJ is a vector, prod(OBJ) returns the product of its elements.
%
%   If OBJ is a matrix, prod(OBJ) returns a row vector containing the
%   product of each column of OBJ.
%
%   obj2 = prod(obj,dim) takes the product along dimension DIM of OBJ.  
%
%   See also: SUM.

if isempty(obj)
    obj2 = obj;
    return
end

if nargin < 2
    dim = 1;
    if isrow(obj)
        dim = 2;
    end
end
validateattributes(dim,{'numeric'},{'integer','scalar','>',0,'<',3}, ...
    'polysym:diff','dim',2)

switch dim
    case 1
        obj2 = obj(1,:);
        for k=2:size(obj,1)
            obj2 = obj2.*obj(k,:);
        end
    case 2
        obj2 = obj(:,1);
        for k=2:size(obj,2)
            obj2 = obj2.*obj(:,k);
        end
end
